/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed.cim;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.cim.ManagedCimErrorIds;
import com.ibm.hwmca.fw.util.ClassDescriptors;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMElement;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMMethod;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMParameter;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMQualifier;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.provider.InstanceProvider;
import org.snia.wbem.provider.MethodProvider;
import org.snia.wbem.provider.PropertyProvider;

public class CimProvider
implements InstanceProvider,
PropertyProvider,
MethodProvider,
ManagedCimErrorIds {
    protected static ClassDescriptors descriptors = ClassDescriptors.getClassDescriptors("CIM");
    protected static ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
    private CIMOMHandle cimomHandle;
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(85, "CimProvider");
    private static final String TRACE_MASKT = "XCIMP  T";
    private static final String TRACE_MASKF = "XCIMP  F";
    private static final String TRACE_MASKD = "XCIMP  D";
    static /* synthetic */ Class class$org$snia$wbem$cim$CIMObjectPath;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ObjectId;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$org$snia$wbem$cim$UnsignedInt64;
    static /* synthetic */ Class class$org$snia$wbem$cim$UnsignedInt32;
    static /* synthetic */ Class class$org$snia$wbem$cim$UnsignedInt16;
    static /* synthetic */ Class class$org$snia$wbem$cim$UnsignedInt8;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public Vector enumInstances(CIMObjectPath path, boolean deep, CIMClass cimClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath path, boolean deep, CIMClass cimClass, boolean localOnly) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath path) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath path, CIMClass cimClass, boolean localOnly) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath path, CIMInstance instance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath path, CIMInstance instance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector execQuery(CIMObjectPath path, String query, int queryLevel, CIMClass cimClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMValue getPropertyValue(CIMObjectPath path, String originClass, String propertyName) throws CIMException {
        throw new CIMException("CIM_ERR_NO_SUCH_PROPERTY", (Object)("Property " + propertyName + " in " + path + " is not supported"));
    }

    public void setPropertyValue(CIMObjectPath path, String originClass, String propertyName, CIMValue newValue) throws CIMException {
        throw new CIMException("CIM_ERR_NO_SUCH_PROPERTY", (Object)("Property " + propertyName + " in " + path + " is not supported"));
    }

    public CIMValue invokeMethod(CIMObjectPath path, String methodName, Vector inParams, Vector outParams) throws CIMException {
        throw new CIMException("CIM_ERR_METHOD_NOT_FOUND", (Object)("Method " + methodName + " in " + path + " is not supported"));
    }

    public void initialize(CIMOMHandle cimomHandle) {
        Trace.trace(TRACE_MASKF, "<> initialize(cimomHandle=" + cimomHandle + ")");
        this.cimomHandle = cimomHandle;
    }

    public void cleanup() {
    }

    public CIMOMHandle getCimomHandle() {
        return this.cimomHandle;
    }

    public static ObjectId objectPathToId(CIMObjectPath path) {
        ObjectId result;
        block5: {
            Trace.trace(TRACE_MASKD, "-> objectPathToId(path=" + path + ")");
            result = null;
            try {
                CIMQualifier qualifier;
                CIMClass javaClass = descriptors.findCimClass(path.getObjectName());
                if (javaClass == null || (qualifier = javaClass.getQualifier("PROVIDER")) == null) break block5;
                Class<?> provider = Class.forName((String)qualifier.getValue().getValue());
                while (true) {
                    try {
                        Method method = provider.getDeclaredMethod("toObjectId", class$org$snia$wbem$cim$CIMObjectPath == null ? (class$org$snia$wbem$cim$CIMObjectPath = CimProvider.class$("org.snia.wbem.cim.CIMObjectPath")) : class$org$snia$wbem$cim$CIMObjectPath);
                        method.setAccessible(true);
                        result = (ObjectId)method.invoke(null, path);
                    }
                    catch (NoSuchMethodException exc) {
                        if ((provider = provider.getSuperclass()) != null) continue;
                        throw exc;
                    }
                    break;
                }
            }
            catch (Exception exc) {
                new FrameworkLog(logInfo, 664, exc).log(LogAttributes.INFO_LOG);
                result = null;
            }
        }
        Trace.trace(TRACE_MASKD, "<- objectPathToId(returns " + result + ")");
        return result;
    }

    public static CIMObjectPath objectIdToPath(ObjectId id) {
        CIMObjectPath result;
        block5: {
            Trace.trace(TRACE_MASKD, "-> objectIdToPath(id=" + id + ")");
            result = null;
            try {
                CIMQualifier qualifier;
                String cimName;
                CIMClass javaClass = descriptors.findClass(id.getFullClassName());
                if (javaClass == null || (cimName = CimProvider.toCimName((CIMElement)javaClass)) == null || (qualifier = javaClass.getQualifier("PROVIDER")) == null) break block5;
                Class<?> provider = Class.forName((String)qualifier.getValue().getValue());
                while (true) {
                    try {
                        Method method = provider.getDeclaredMethod("toObjectPath", class$com$ibm$hwmca$fw$managed$ObjectId == null ? (class$com$ibm$hwmca$fw$managed$ObjectId = CimProvider.class$("com.ibm.hwmca.fw.managed.ObjectId")) : class$com$ibm$hwmca$fw$managed$ObjectId);
                        method.setAccessible(true);
                        result = (CIMObjectPath)method.invoke(null, id);
                    }
                    catch (NoSuchMethodException exc) {
                        if ((provider = provider.getSuperclass()) != null) continue;
                        throw exc;
                    }
                    break;
                }
            }
            catch (Exception exc) {
                new FrameworkLog(logInfo, 665, exc).log(LogAttributes.INFO_LOG);
                result = null;
            }
        }
        Trace.trace(TRACE_MASKD, "<- objectIdToPath(returns " + result + ")");
        return result;
    }

    protected CIMValue getPropertyValue(Object javaInstance, String originClass, String propertyName) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> getPropertyValue(javaInstance=" + javaInstance + ",propertyName=" + propertyName + ")");
        CIMValue result = null;
        try {
            CIMClass cimClass = descriptors.findClass(javaInstance.getClass().getName());
            if (cimClass == null) {
                throw new CIMException("CIM_ERR_FAILED", (Object)("Class " + javaInstance + " not found"));
            }
            CIMProperty cimProperty = descriptors.findProperty(cimClass, propertyName);
            if (cimProperty == null) {
                throw new CIMException("CIM_ERR_NO_SUCH_PROPERTY", (Object)propertyName);
            }
            CIMMethod cimMethod = descriptors.findGetMethod(cimProperty);
            if (cimMethod == null) {
                throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)("An accessor method does not exist for property " + propertyName));
            }
            Object propertyValue = descriptors.invokeMethod(cimMethod, javaInstance, null);
            result = CimProvider.toCimValue(propertyValue, (CIMElement)cimProperty);
        }
        catch (NoSuchMethodException exc) {
            Trace.trace(TRACE_MASKF, "A get method was not found for property " + propertyName);
            Trace.trace(TRACE_MASKF, exc);
            throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)("An accessor method does not exist for property " + propertyName));
        }
        Trace.trace(TRACE_MASKT, "<- getPropertyValue(returns " + result + ")");
        return result;
    }

    protected void setPropertyValue(Object javaInstance, String originClass, String propertyName, CIMValue newValue) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> setPropertyValue(javaInstance=" + javaInstance + ")");
        try {
            CIMClass cimClass = descriptors.findClass(javaInstance.getClass().getName());
            if (cimClass == null) {
                throw new CIMException("CIM_ERR_FAILED", (Object)("Class " + javaInstance + " not found"));
            }
            CIMProperty cimProperty = descriptors.findProperty(cimClass, propertyName);
            if (cimProperty == null) {
                throw new CIMException("CIM_ERR_NO_SUCH_PROPERTY", (Object)propertyName);
            }
            CIMMethod cimMethod = descriptors.findSetMethod(cimProperty);
            if (cimMethod == null) {
                throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)("A set method does not exist for property " + propertyName));
            }
            Object[] args = new Object[]{CimProvider.toJavaValue(newValue)};
            descriptors.invokeMethod(cimMethod, javaInstance, args);
        }
        catch (NoSuchMethodException exc) {
            Trace.trace(TRACE_MASKF, "A set method was not found for property " + propertyName);
            Trace.trace(TRACE_MASKF, exc);
            throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)("An accessor method does not exist for property " + propertyName));
        }
        Trace.trace(TRACE_MASKT, "<- setPropertyValue()");
    }

    protected static ObjectId toObjectId(CIMObjectPath path) {
        CIMClass javaClass = descriptors.findCimClass(path.getObjectName());
        ObjectId result = new ObjectId(javaClass.getName());
        Iterator iterator = path.getKeys().iterator();
        while (iterator.hasNext()) {
            CIMProperty cimProperty = (CIMProperty)iterator.next();
            String propertyName = cimProperty.getName();
            result.setKeyProperty(propertyName, CimProvider.toJavaValue(cimProperty.getValue()));
        }
        Trace.trace(TRACE_MASKD, "<> toObjectId(path=" + path + " returns " + result + ")");
        return result;
    }

    protected static CIMObjectPath toObjectPath(ObjectId id) {
        CIMObjectPath result = null;
        CIMClass javaClass = descriptors.findClass(id.getFullClassName());
        if (javaClass != null) {
            result = new CIMObjectPath(CimProvider.toCimName((CIMElement)javaClass), "root");
            Vector<CIMProperty> keys = new Vector<CIMProperty>();
            Iterator iterator = id.getKeyProperties().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry property = iterator.next();
                CIMValue value = CimProvider.toCimValue(property.getValue());
                if (value == null) {
                    result = null;
                    break;
                }
                keys.add(new CIMProperty((String)property.getKey(), value));
            }
            if (result != null) {
                result.setKeys(keys);
            }
        }
        Trace.trace(TRACE_MASKD, "<> toObjectPath(id=" + id + " returns " + result + ")");
        return result;
    }

    public static Object toJavaValue(CIMValue cimValue) {
        Object result = null;
        if (cimValue != null && !cimValue.isNullValue()) {
            CIMDataType type = cimValue.getType();
            if (type.isArrayType()) {
                Vector value = (Vector)cimValue.getValue();
                switch (type.getType()) {
                    case 30: {
                        result = Array.newInstance(Boolean.TYPE, value.size());
                        break;
                    }
                    case 34: {
                        result = Array.newInstance(Character.TYPE, value.size());
                        break;
                    }
                    case 33: {
                        result = Array.newInstance(class$java$util$Date == null ? (class$java$util$Date = CimProvider.class$("java.util.Date")) : class$java$util$Date, value.size());
                        break;
                    }
                    case 31: {
                        result = Array.newInstance(Float.TYPE, value.size());
                        break;
                    }
                    case 32: {
                        result = Array.newInstance(Double.TYPE, value.size());
                        break;
                    }
                    case 22: {
                        result = Array.newInstance(Byte.TYPE, value.size());
                        break;
                    }
                    case 21: 
                    case 24: {
                        result = Array.newInstance(Short.TYPE, value.size());
                        break;
                    }
                    case 23: 
                    case 26: {
                        result = Array.newInstance(Integer.TYPE, value.size());
                        break;
                    }
                    case 25: 
                    case 28: {
                        result = Array.newInstance(Long.TYPE, value.size());
                        break;
                    }
                    case 27: {
                        result = Array.newInstance(class$java$math$BigInteger == null ? (class$java$math$BigInteger = CimProvider.class$("java.math.BigInteger")) : class$java$math$BigInteger, value.size());
                        break;
                    }
                    case 29: {
                        result = Array.newInstance(class$java$lang$String == null ? (class$java$lang$String = CimProvider.class$("java.lang.String")) : class$java$lang$String, value.size());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid array data type: " + type.getType());
                    }
                }
                for (int ix = 0; ix < value.size(); ++ix) {
                    Array.set(result, ix, value.elementAt(ix));
                }
            } else {
                result = type.isReferenceType() ? CimProvider.objectPathToId((CIMObjectPath)cimValue.getValue()) : cimValue.getValue();
            }
        }
        Trace.trace(TRACE_MASKD, "<> toJavaValue(cimValue=" + cimValue + " returns " + result.getClass().getName() + ":" + result + ")");
        return result;
    }

    public static Object[] toJavaValues(Vector cimValues) {
        Trace.trace(TRACE_MASKD, "-> toJavaValues()");
        Object[] result = null;
        if (cimValues != null) {
            result = new Object[cimValues.size()];
            for (int ix = 0; ix < cimValues.size(); ++ix) {
                result[ix] = CimProvider.toJavaValue((CIMValue)cimValues.elementAt(ix));
            }
        }
        Trace.trace(TRACE_MASKD, "<- toJavaValues()");
        return result;
    }

    public static CIMValue toCimValue(Object value) {
        return CimProvider.toCimValue(value, null);
    }

    public static CIMValue toCimValue(Object value, CIMElement javaElement) {
        CIMValue result = null;
        if (value == null) {
            result = new CIMValue((Object)value);
        } else {
            CIMDataType cimType = null;
            if (javaElement != null) {
                cimType = CimProvider.toCimType(javaElement);
            }
            if (value instanceof Map || value instanceof Collection) {
                Collection values = value;
                if (values != null) {
                    if (values instanceof Map) {
                        values = ((Map)((Object)values)).values();
                    }
                    values = new Vector(values);
                }
                result = cimType == null ? new CIMValue((Object)values) : new CIMValue(values, cimType);
            } else if (cimType != null && cimType.isReferenceType()) {
                CIMClass cimClass = descriptors.findClass(cimType.getRefClassName());
                if (cimClass == null) {
                    result = new CIMValue((Object)value.toString());
                } else {
                    cimType = new CIMDataType(CimProvider.toCimName((CIMElement)cimClass));
                    result = new CIMValue(value, cimType);
                }
            } else if (value.getClass().isArray()) {
                Vector<Object> values = new Vector<Object>();
                for (int ix = 0; ix < Array.getLength(value); ++ix) {
                    values.add(Array.get(value, ix));
                }
                if (cimType == null) {
                    result = new CIMValue(values);
                } else {
                    if (!cimType.isArrayType()) {
                        cimType = new CIMDataType(CIMDataType.findArrayType((int)cimType.getType()));
                    }
                    result = new CIMValue(values, cimType);
                }
            } else if (value instanceof ObjectId) {
                CIMObjectPath path = CimProvider.objectIdToPath((ObjectId)((Object)value));
                if (path != null) {
                    result = new CIMValue((Object)path);
                }
            } else {
                try {
                    result = new CIMValue(value);
                }
                catch (ExceptionInInitializerError error) {
                    result = new CIMValue((Object)value.toString());
                }
            }
        }
        Trace.trace(TRACE_MASKD, "<> toCimValue(value=" + value + ",javaElement=" + (javaElement == null ? "null" : javaElement.getName()) + " returns " + result + ")");
        return result;
    }

    public static CIMDataType toCimType(CIMElement javaElement) {
        CIMQualifier typeQualifier;
        CIMDataType javaType = null;
        if (javaElement instanceof CIMProperty) {
            javaType = ((CIMProperty)javaElement).getType();
            typeQualifier = ((CIMProperty)javaElement).getQualifier("HWMCA_CIMTYPE");
            if (typeQualifier != null) {
                int cimDataType = CimProvider.toCimType((String)typeQualifier.getValue().getValue());
                if (javaType.isArrayType()) {
                    cimDataType = CIMDataType.findArrayType((int)cimDataType);
                }
                javaType = new CIMDataType(cimDataType);
            }
        } else if (javaElement instanceof CIMMethod) {
            Vector parameters = ((CIMMethod)javaElement).getParameters();
            Iterator iterator = parameters.iterator();
            while (iterator.hasNext()) {
                CIMParameter parameter = (CIMParameter)iterator.next();
                if (!parameter.getName().equals("HWMCA_RETURN_REFERENCE")) continue;
                javaType = parameter.getType();
                CIMQualifier typeQualifier2 = parameter.getQualifier("HWMCA_CIMTYPE");
                if (typeQualifier2 == null) continue;
                int cimDataType = CimProvider.toCimType((String)typeQualifier2.getValue().getValue());
                if (javaType.isArrayType()) {
                    cimDataType = CIMDataType.findArrayType((int)cimDataType);
                }
                javaType = new CIMDataType(cimDataType);
            }
        } else if (javaElement instanceof CIMParameter) {
            javaType = ((CIMParameter)javaElement).getType();
            typeQualifier = ((CIMParameter)javaElement).getQualifier("HWMCA_CIMTYPE");
            if (typeQualifier != null) {
                int cimDataType = CimProvider.toCimType((String)typeQualifier.getValue().getValue());
                if (javaType.isArrayType()) {
                    cimDataType = CIMDataType.findArrayType((int)cimDataType);
                }
                javaType = new CIMDataType(cimDataType);
            }
        } else {
            throw new IllegalArgumentException("The Java element must be of type CIMProperty, CIMMethod or CIMParameter");
        }
        CIMDataType result = javaType;
        if (javaType.isReferenceType()) {
            try {
                Class<?> refClass = Class.forName(javaType.getRefClassName());
                if ((class$java$util$Map == null ? (class$java$util$Map = CimProvider.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(refClass) || (class$java$util$Collection == null ? (class$java$util$Collection = CimProvider.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(refClass)) {
                    String referenceClassName = null;
                    CIMQualifier qualifier = null;
                    if (javaElement != null) {
                        if (javaElement instanceof CIMProperty) {
                            qualifier = ((CIMProperty)javaElement).getQualifier("HWMCA_REFERENCECLASS");
                        } else if (javaElement instanceof CIMMethod) {
                            qualifier = ((CIMMethod)javaElement).getQualifier("HWMCA_REFERENCECLASS");
                        } else if (javaElement instanceof CIMParameter) {
                            qualifier = ((CIMParameter)javaElement).getQualifier("HWMCA_REFERENCECLASS");
                        } else {
                            throw new IllegalArgumentException("The Java element must be of type CIMProperty, CIMMethod or CIMParameter");
                        }
                    }
                    if (qualifier != null) {
                        referenceClassName = (String)qualifier.getValue().getValue();
                    }
                    result = referenceClassName == null ? new CIMDataType(29) : (referenceClassName.equals("java.lang.Boolean") ? new CIMDataType(30) : (referenceClassName.equals("java.lang.Long") ? new CIMDataType(28) : (referenceClassName.equals("java.lang.Integer") ? new CIMDataType(26) : (referenceClassName.equals("java.lang.Short") ? new CIMDataType(24) : (referenceClassName.equals("java.lang.Byte") ? new CIMDataType(22) : (referenceClassName.equals("java.lang.Double") ? new CIMDataType(32) : (referenceClassName.equals("java.lang.Float") ? new CIMDataType(31) : (referenceClassName.equals("java.lang.Character") ? new CIMDataType(34) : (referenceClassName.equals("java.util.Calendar") || referenceClassName.equals("java.util.Date") ? new CIMDataType(33) : (referenceClassName.equals((class$org$snia$wbem$cim$UnsignedInt64 == null ? (class$org$snia$wbem$cim$UnsignedInt64 = CimProvider.class$("org.snia.wbem.cim.UnsignedInt64")) : class$org$snia$wbem$cim$UnsignedInt64).getName()) ? new CIMDataType(27) : (referenceClassName.equals((class$org$snia$wbem$cim$UnsignedInt32 == null ? (class$org$snia$wbem$cim$UnsignedInt32 = CimProvider.class$("org.snia.wbem.cim.UnsignedInt32")) : class$org$snia$wbem$cim$UnsignedInt32).getName()) ? new CIMDataType(25) : (referenceClassName.equals((class$org$snia$wbem$cim$UnsignedInt16 == null ? (class$org$snia$wbem$cim$UnsignedInt16 = CimProvider.class$("org.snia.wbem.cim.UnsignedInt16")) : class$org$snia$wbem$cim$UnsignedInt16).getName()) ? new CIMDataType(23) : (referenceClassName.equals((class$org$snia$wbem$cim$UnsignedInt8 == null ? (class$org$snia$wbem$cim$UnsignedInt8 = CimProvider.class$("org.snia.wbem.cim.UnsignedInt8")) : class$org$snia$wbem$cim$UnsignedInt8).getName()) ? new CIMDataType(21) : new CIMDataType(29))))))))))))));
                } else {
                    CIMClass cimClass;
                    result = (class$java$lang$Boolean == null ? (class$java$lang$Boolean = CimProvider.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(refClass) ? new CIMDataType(10) : ((class$java$lang$Character == null ? (class$java$lang$Character = CimProvider.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(refClass) ? new CIMDataType(14) : ((class$java$lang$Byte == null ? (class$java$lang$Byte = CimProvider.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(refClass) ? new CIMDataType(2) : ((class$java$lang$Short == null ? (class$java$lang$Short = CimProvider.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(refClass) ? new CIMDataType(4) : ((class$java$lang$Integer == null ? (class$java$lang$Integer = CimProvider.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(refClass) ? new CIMDataType(6) : ((class$java$lang$Long == null ? (class$java$lang$Long = CimProvider.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(refClass) ? new CIMDataType(8) : ((class$java$lang$Float == null ? (class$java$lang$Float = CimProvider.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(refClass) ? new CIMDataType(11) : ((class$java$lang$Double == null ? (class$java$lang$Double = CimProvider.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(refClass) ? new CIMDataType(12) : ((cimClass = descriptors.findClass(javaType.getRefClassName())) == null ? new CIMDataType(9) : new CIMDataType(CimProvider.toCimName((CIMElement)cimClass))))))))));
                }
            }
            catch (Exception exc) {
                new FrameworkLog(logInfo, 666, exc).log(LogAttributes.INFO_LOG);
            }
        }
        Trace.trace(TRACE_MASKD, "<> toCimType(javaElement=" + (javaElement == null ? "null" : javaElement.getName()) + " returns " + result + ")");
        return result;
    }

    private static int toCimType(String type) {
        int result = 0;
        if ((type = type.intern()) == "uint8") {
            result = 1;
        } else if (type == "uint16") {
            result = 3;
        } else if (type == "uint32") {
            result = 5;
        } else if (type == "uint64") {
            result = 7;
        } else if (type == "sint8") {
            result = 2;
        } else if (type == "sint16") {
            result = 4;
        } else if (type == "sint32") {
            result = 6;
        } else if (type == "sint64") {
            result = 8;
        } else if (type == "real32") {
            result = 11;
        } else if (type == "real64") {
            result = 12;
        } else if (type == "boolean") {
            result = 10;
        } else if (type == "char16") {
            result = 14;
        } else if (type == "datetime") {
            result = 13;
        } else if (type == "string") {
            result = 9;
        } else {
            throw new IllegalArgumentException("Invalid CIM data type: " + type);
        }
        return result;
    }

    public static String toCimName(CIMElement javaElement) {
        String name = null;
        CIMQualifier cimQualifier = null;
        if (javaElement instanceof CIMClass) {
            cimQualifier = ((CIMClass)javaElement).getQualifier("HWMCA_CIMNAME");
        } else if (javaElement instanceof CIMProperty) {
            cimQualifier = ((CIMProperty)javaElement).getQualifier("HWMCA_CIMNAME");
        } else if (javaElement instanceof CIMMethod) {
            cimQualifier = ((CIMMethod)javaElement).getQualifier("HWMCA_CIMNAME");
        } else if (javaElement instanceof CIMParameter) {
            cimQualifier = ((CIMParameter)javaElement).getQualifier("HWMCA_CIMNAME");
        } else {
            throw new IllegalArgumentException("The Java element must be of type CIMClass, CIMProperty, CIMMethod or CIMParameter");
        }
        if (cimQualifier == null) {
            int ix;
            name = javaElement.getName();
            if (javaElement instanceof CIMClass && (ix = name.lastIndexOf(46)) > 0) {
                name = name.substring(ix + 1);
            }
            name = name.substring(0, 1).toUpperCase() + name.substring(1);
        } else {
            name = (String)cimQualifier.getValue().getValue();
        }
        Trace.trace(TRACE_MASKD, "<> toCimName(javaElement=" + javaElement.getName() + " returns " + name + ")");
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

